<?php
// Start session if needed
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

header('Content-Type: application/json');

require 'vendor/autoload.php';

use Adldap\Adldap;

$response = [
    'success' => false,
    'message' => '',
    'user' => null,
];

// Detect if Content-Type is application/json
$contentType = $_SERVER['CONTENT_TYPE'] ?? '';

if (stripos($contentType, 'application/json') !== false) {
    $input = json_decode(file_get_contents('php://input'), true);
    $username = $input['username'] ?? '';
    $password = $input['password'] ?? '';
} else {
    // Handle application/x-www-form-urlencoded
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
}

if (empty($username) || empty($password)) {
    $response['message'] = 'Username and password are required.';
    echo json_encode($response);
    exit;
}

// LDAP config
$config = [
    'hosts' => ['192.168.201.2'],
    'base_dn' => 'DC=raimonairways,DC=net',
    'username' => "raimonairways\\$username",
    'password' => $password,
];

try {
    $ad = new Adldap();
    $ad->addProvider($config);
    $provider = $ad->connect();

    $user = $provider->search()->where('samaccountname', '=', $username)->first();

    if ($user) {
        $userData = [
            'displayname' => $user->getCommonName(),
            'mail' => $user->getEmail(),
            'msrtcsip_line' => $user->getAttribute('msrtcsip-line')[0] ?? '',
            'samaccountname' => $user->getAccountName(),
            'givenname' => $user->getFirstName(),
            'surname' => $user->getLastName(),
            'department' => $user->getAttribute('department')[0] ?? '',
            'title' => $user->getAttribute('title')[0] ?? '',
            'telephoneNumber' => $user->getAttribute('telephoneNumber')[0] ?? '',
            'mobile' => $user->getAttribute('mobile')[0] ?? '',
            'physicalDeliveryOfficeName' => $user->getAttribute('physicalDeliveryOfficeName')[0] ?? '',
            'manager' => $user->getAttribute('manager')[0] ?? '',
            'memberOf' => $user->getAttribute('memberOf') ?? [],
        ];

        $_SESSION['user'] = $userData;

        $response['success'] = true;
        $response['message'] = 'Authentication successful.';
        $response['user'] = $userData;
    } else {
        $response['message'] = 'User not found in the directory.';
    }
} catch (\Adldap\Auth\BindException $e) {
    $response['message'] = 'LDAP Authentication failed: ' . $e->getMessage();
} catch (Exception $e) {
    $response['message'] = 'An error occurred: ' . $e->getMessage();
}

echo json_encode($response);